#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "dllexport.h"
class IDevUserLogin;

typedef struct
{
    DWORD    dwYear;
    DWORD    dwMonth;
    DWORD    dwDay;
    DWORD    dwHour;
    DWORD    dwMinute;
    DWORD    dwSecond;
} TIME, *LPTIME;

typedef enum  
{
	FILETYPE_ALL = 0xFF,
	FILETYPE_Time = 0,
	FILETYPE_MD,
	FILETYPE_AlarmTrigger,
	FILETYPE_AlarmOrMD,
	FILETYPE_AlarmAndMD,
	FILETYPE_CmdTrigger,
	FILETYPE_Manual,
	FILETYPE_Max
} FILETYPE;

typedef struct tagSearchFileCondition
{
    LONG   lChannel;
    DWORD  dwFileType;
    TIME   startTime;
    TIME   stopTime;
} SearchFileCondition;

typedef struct tagSearchEventCondition
{
    DWORD  dwMajorType;
    DWORD  dwMinorType;
    TIME   startTime;
    TIME   endTime;
} SearchEventCondition;

typedef struct tagRemoteFileInfo
{
    LONG   lChannel;
    char   sFileName[256];
    TIME   startTime;
    TIME   stopTime;
    DWORD  dwFileSize;
    DWORD  dwLocked;
    DWORD  dwRecordFileType;
} RemoteFileInfo;

class DLLAPI CDevRemoteFileFinder
{
public:
    CDevRemoteFileFinder(IDevUserLogin *pUser, SearchFileCondition *fileCond) { UNUSED_ARG(pUser); UNUSED_ARG(fileCond); return; }
    CDevRemoteFileFinder(IDevUserLogin *pUser, SearchEventCondition *evnetCond) { UNUSED_ARG(pUser); UNUSED_ARG(evnetCond); return; }
    virtual ~CDevRemoteFileFinder() { FindClose(); }
    virtual BOOL FindNextFile(RemoteFileInfo *fileInfo) = 0;
    virtual BOOL FindClose() { return TRUE; }
};

class DLLAPI CDevRemoteFileDownloader
{
public:
    CDevRemoteFileDownloader(IDevUserLogin *pUser, char *sDVRFileName, char *sSavedFileName) 
    { 
        UNUSED_ARG(pUser);
        UNUSED_ARG(sDVRFileName);
        UNUSED_ARG(sSavedFileName);
        return;
    }
    CDevRemoteFileDownloader(IDevUserLogin *pUser, LONG lChannel, LPTIME lpStartTime, LPTIME lpStopTime, char *sSavedFileName) 
    { 
        UNUSED_ARG(pUser);
        UNUSED_ARG(lChannel);
        UNUSED_ARG(lpStartTime);
        UNUSED_ARG(lpStopTime);
        UNUSED_ARG(sSavedFileName);
        return; 
    }
    virtual ~CDevRemoteFileDownloader() { Stop(); }
	virtual BOOL H264toAvi() = 0;
	virtual int GetProgress() = 0;
    virtual BOOL Start() = 0;   
    virtual BOOL Stop() { return TRUE; }
    virtual BOOL IsDownloading() { return TRUE; }
};

class DLLAPI CDevRemotePlayback
{
public:
    CDevRemotePlayback(IDevUserLogin *pUser, HWND hWnd, char *sPlayBackFileName) 
    { 
        UNUSED_ARG(pUser);
        UNUSED_ARG(hWnd);
        UNUSED_ARG(sPlayBackFileName);
        return; 
    }
    CDevRemotePlayback(IDevUserLogin *pUser, HWND hWnd, LONG lChannel, LPTIME lpStartTime, LPTIME lpStopTime) 
    { 
        UNUSED_ARG(pUser);
        UNUSED_ARG(lChannel);
        UNUSED_ARG(lpStartTime);
        UNUSED_ARG(lpStopTime);
        UNUSED_ARG(hWnd);
        return; 
    }
    virtual ~CDevRemotePlayback() { Stop(); }
    virtual BOOL Start(DWORD dwOffset) = 0;
    virtual BOOL Pause() = 0;
    virtual BOOL Resume() = 0;
    virtual BOOL Faster() = 0;
    virtual BOOL Slower() = 0;
	virtual BOOL OneByOne() = 0;
    virtual BOOL Normal() = 0;
    virtual BOOL ThrowBFrame() = 0;
    virtual BOOL PlayBackSaveData() = 0;
    virtual BOOL PlayBackCaptureFile() = 0;
    virtual BOOL StopPlayBackSave() = 0;
    virtual void SetPlayDataCallBack() = 0;
    virtual BOOL GetPlayBackOsdTime(LPTIME lpOsdTime) = 0;
    virtual BOOL Stop() { return TRUE; }
	virtual BOOL Capture(char *pFileName) = 0;
    virtual BOOL StartAudio() = 0;
    virtual BOOL StopAudio() = 0;
    virtual BOOL SetPos(float fPos) = 0;
    virtual float GetPos() = 0;
    virtual BOOL GetFrames(DWORD *dwFrame) = 0;
    virtual BOOL GetTime(DWORD *dwTime) = 0;
    virtual BOOL GetTotalFrames(DWORD *dwTotal) = 0;
    virtual BOOL GetTotalTime(DWORD *dwTotal) = 0;
    virtual BOOL SetVolume(DWORD dwVolume) = 0;
};


class DLLAPI CDevRemoteFileFinderFactory
{
public:
    static CDevRemoteFileFinder *CreateFinder(IDevUserLogin *pUser, SearchFileCondition *fileCond);
    static CDevRemoteFileFinder *CreateFinder(IDevUserLogin *pUser, SearchEventCondition *evnetCond);
    static void DeleteFinder(CDevRemoteFileFinder *finder);
};


class DLLAPI CDevRemoteFileDownloaderFactory
{
public:
    static CDevRemoteFileDownloader *CreateDownloader(IDevUserLogin *pUser, char *sDVRFileName, char *sSavedFileName);
    static CDevRemoteFileDownloader *CreateDownloader(IDevUserLogin *pUser, LONG lChannel, LPTIME lpStartTime, LPTIME lpStopTime, char *sSavedFileName);
    static void DeleteDownloader(CDevRemoteFileDownloader *downloader);
};

class DLLAPI CDevRemotePlaybackFactory
{
public:
    static CDevRemotePlayback *CreateRemotePlayback(IDevUserLogin *pUser, HWND hWnd, char *sPlayBackFileName);
    static CDevRemotePlayback *CreateRemotePlayback(IDevUserLogin *pUser, HWND hWnd, LONG lChannel, LPTIME lpStartTime, LPTIME lpStopTime);
    static void DeleteRemotePlayback(CDevRemotePlayback *rp);
};
